import {push} from 'connected-react-router';
import {switchToModeRestoreLoginSuccess, setupBackPane} from './';

export default function switchToModeRestoreLogin() {
    return (dispatch, getState) => {
        const {
            common: {restoreLoginUrl},
            auth: {mode},
            router = {},
            am = {}
        } = getState();
        const {location = {}} = router;
        const {pathname} = location;

        if (mode === 'restoreLogin') {
            return;
        }

        if (am.isAm && pathname) {
            dispatch(setupBackPane(pathname));
        }

        dispatch(switchToModeRestoreLoginSuccess());
        dispatch(push(restoreLoginUrl));
    };
}
