import {push} from 'connected-react-router';
import {
    ENTRY_RESTORE_ROUTE,
    ENTRY_RESTORE_PROCESS,
    ENTRY_RESTORE_NEOPHONISH_ROUTE,
    ENTRY_RESTORE_NEOPHONISH_PROCESS
} from '@blocks/UserEntryFlow/processes';
import {initWithPhoneConfirmation} from '@blocks/UserEntryFlow/logic';
import {setProcessError} from '@blocks/UserEntryFlow/actions';
import {setupBackPane, setupPane} from '@blocks/common/actions';
import {setupMode} from '@blocks/authv2/actions/index';
import {getAdvancedError} from '@blocks/utils';
import {domikIsLoading} from '@blocks/auth/actions';
import api from '@blocks/api';

export const switchToModeRestoreLoginWithPhone = ({phone, processName = ENTRY_RESTORE_PROCESS}) => (
    dispatch,
    getState
) => {
    const state = getState();
    const {router = {}, common = {}, am = {}} = state;
    const {location = {}} = router;
    const {search} = location;
    const {pane} = common;
    const {isAm} = am;

    let pathname;

    switch (processName) {
        case ENTRY_RESTORE_NEOPHONISH_PROCESS: {
            pathname = ENTRY_RESTORE_NEOPHONISH_ROUTE;
            break;
        }

        case ENTRY_RESTORE_PROCESS:
        default: {
            pathname = ENTRY_RESTORE_ROUTE;
            break;
        }
    }

    const route = `${pathname}${search}`;

    if (!isAm) {
        dispatch(setupBackPane(pane));
    }

    dispatch(setupPane(route));
    dispatch(setupMode('restoreLogin'));

    if (!phone) {
        dispatch(push(route));
        dispatch(domikIsLoading(false));
        return;
    }

    api.userEntryFlowSubmit({process: processName})
        .then(() => dispatch(initWithPhoneConfirmation({phone, route, processName})))
        .catch(() => {
            dispatch(setProcessError(getAdvancedError('global', 'global')));
            dispatch(push(route));
        });
};
