import {push} from 'connected-react-router';
import {setupBackPane, setupMode} from './';
import {setupPane} from '../../common/actions';
import metrics from '../../metrics';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_SOURCE_AUTH} from '../metrics_constants';

export default function switchToRestorePassword() {
    return (dispatch, getState) => {
        const {
            common: {
                restorePasswordUrl,
                restorePasswordCaptchaUrl,
                addUserUrl,
                experiments: {flags}
            },
            auth: {
                form: {login}
            },
            restorePassword: {errors}
        } = getState();
        const isErrorStatus = Boolean(errors.code);
        const finalUrlWithExp = !isErrorStatus && login ? restorePasswordCaptchaUrl : restorePasswordUrl;

        dispatch(setupBackPane(addUserUrl));
        dispatch(setupPane(finalUrlWithExp));
        dispatch(setupMode('restore-password'));
        dispatch(push(finalUrlWithExp));
        metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_SOURCE_AUTH}, эксперимент: ${flags}`]);
    };
}
