import passport from '@plibs/pclientjs/js/passport';
import broker from '@old-blocks/social/broker';
import metrics from '@blocks/metrics';
import {storageAvailable} from '@blocks/utils';
import redirectToBackpath from './actions/redirectToBackpath';
import redirectToRetpath from './actions/redirectToRetpath';
import switchToModeMagic from './actions/switchToModeMagic';
import {initSocialSuggestProcess} from './actions/socialSuggest';
import {switchToModeSocialSuggest} from './actions/switchToModeSocialSuggest';
import {domikIsLoading} from '@blocks/auth/actions';
import {setIsAM} from '@blocks/common/actions';
import api from '@blocks/api';

const SOCIAL_AUTH_SUCCESS = 'Успешная авторизация с помощью соц.сети';
const SOCIAL_AUTH_SUCCESS_GOAL = 'one_domik_social_auth_sucess';
const REMOVE_ITEM_TIMEOUT = 2500;

let store;
const brokerWrapper = {
    init(s) {
        const self = this;

        self.setStore(s);

        const {
            social: {
                brokerParams: {startUrl}
            },
            common: {retpath, backpath, origin, isWebView},
            settings = {},
            auth = {},
            customs = {}
        } = self.getStore().getState();
        const processUUID = auth.process_uuid || settings.process_uuid;
        const display = customs.display;

        const brokerParams = {};

        let retpathUrl = retpath || `${location.protocol}//${location.host}/profile`;

        if (origin === 'yandex') {
            retpathUrl = backpath || `${location.protocol}//${location.host}/profile`;
        }

        brokerParams.resize = 1;
        brokerParams.startUrl = startUrl;

        if (display === 'popup' || display === 'touch' || self.isTouch() || isWebView) {
            brokerParams.display = 'touch';
            brokerParams.retnopopup = retpathUrl;
        }

        brokerParams.process_uuid = processUUID;

        if (window.addEventListener) {
            window.addEventListener('message', self.onSuccess.bind(this));

            if (storageAvailable('localStorage')) {
                window.addEventListener('storage', function(event) {
                    if (event.isTrusted && event.key === 'socialResponse') {
                        self.emitEventWithDataFromStorage();
                    }
                });
            }
        } else if (window.attachEvent) {
            window.attachEvent('onmessage', self.onSuccess.bind(this));
        }

        if (!window.location.origin) {
            window.location.origin = `${window.location.protocol}//${window.location.hostname}`;
        }

        window.socialResponse = function(data) {
            self.onSuccess({
                // eslint-disable-next-line compat/compat
                origin: location.origin,
                data
            });
        };

        broker.init(brokerParams);
    },

    getStore() {
        return store;
    },

    isTouch() {
        return passport.isTouch;
    },

    setStore(s) {
        store = s;
    },

    maybeEmitEventWithDataFromStorage() {
        if (passport.util.getCookie('process') === 'socialSuggest') {
            store.dispatch(domikIsLoading(true));

            api.socialAuthCallback()
                .then((response) => {
                    const {suggest} = response;

                    store.dispatch(domikIsLoading(false));
                    this.initSocialSuggestProcess(suggest);
                    this.clearCookies();
                })
                .catch(() => {
                    // TODO error?
                    store.dispatch(domikIsLoading(false));
                    this.clearCookies();
                });
        }

        if (storageAvailable('localStorage')) {
            if (window.localStorage.getItem('process') === 'socialSuggest') {
                this.emitEventWithDataFromStorage();

                setTimeout(() => {
                    window.localStorage.removeItem('process');
                }, REMOVE_ITEM_TIMEOUT);
            }
        }
    },

    clearCookies() {
        document.cookie = 'process=;path=/;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        document.cookie = 'socialParams=;path=/;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
    },

    emitEventWithDataFromStorage() {
        const data = JSON.parse(window.localStorage.getItem('socialResponse'));

        if (data) {
            this.onSuccess({
                origin: location.origin,
                data
            });

            setTimeout(() => {
                window.localStorage.removeItem('socialResponse');
            }, REMOVE_ITEM_TIMEOUT);
        }
    },

    initSocialSuggestProcess(suggest = {}) {
        const {isAM} = suggest;

        store.dispatch(setIsAM(isAM));
        store.dispatch(initSocialSuggestProcess(suggest));
        store.dispatch(switchToModeSocialSuggest());
    },

    onSuccess(message = {}) {
        const store = this.getStore();
        const {origin, data = {}} = message;
        const {socialAuth, status, goToMagic, socialSuggest, suggest} = data;
        const {
            common: {origin: reqOrigin, pane = ''}
        } = store.getState();

        if (origin !== location.origin) {
            return;
        }

        if (!socialAuth && !socialSuggest) {
            return;
        }

        if (socialSuggest) {
            this.initSocialSuggestProcess(suggest);
            return;
        }

        if (pane.match(/\/auth\/social/)) {
            return;
        }

        if (status === 'ok') {
            if (goToMagic) {
                return store.dispatch(switchToModeMagic(false));
            }

            metrics.send([SOCIAL_AUTH_SUCCESS]);

            metrics.goal(SOCIAL_AUTH_SUCCESS_GOAL);

            if (reqOrigin === 'yandex') {
                store.dispatch(redirectToBackpath());
            } else {
                store.dispatch(redirectToRetpath());
            }
        }
    },

    start(params) {
        broker.start(params);
    }
};

export default brokerWrapper;
