import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import prepareProps from './prepareProps';
import {ContextMenuButton} from '@blocks/authv2/components/AccountList/ContextMenuButton';

const b = cn('AuthAccountListItem');

export const AccountListItem = (props) => {
    const {
        fallbackUrl,
        socialProvider,
        avatarStyle,
        displayName,
        displayLogin,
        isDefault,
        hasSocial,
        hasPlus,
        onClick,
        uid,
        isSuggested,
        isDefaultAvatar
    } = prepareProps(props);

    return (
        <div className={b('block')} data-t='account-list-item'>
            <a
                href={fallbackUrl || '#'}
                onClick={onClick}
                data-t='account-list-item-info'
                className={b({
                    default: isDefault,
                    socialMethod: !isDefault && hasSocial,
                    withoutLogin: !displayLogin,
                    [`socialMethod_${socialProvider}`]: !isDefault && hasSocial
                })}
            >
                <div className={b('inner')}>
                    <span className={b('avatar', {isDefaultAvatar, hasPlus})} style={avatarStyle} />
                    <div className='displayNameInfoWrap'>
                        <div className={b('displayName')}>{displayName}</div>
                        {displayLogin && (
                            <span className={b('login')} dir='ltr'>
                                {displayLogin}
                            </span>
                        )}
                    </div>
                </div>
            </a>

            <ContextMenuButton uid={uid} type={isSuggested ? 'forget' : 'logout'} />
        </div>
    );
};

AccountListItem.propTypes = {
    account: PropTypes.shape({
        avatarId: PropTypes.string.isRequired,
        displayName: PropTypes.string.isRequired,
        login: PropTypes.string.isRequired,
        hasSocial: PropTypes.bool,
        mail: PropTypes.string,
        socialProvider: PropTypes.string
    }).isRequired,
    avatarSettings: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }).isRequired,
    isDefault: PropTypes.bool.isRequired,
    isSuggested: PropTypes.bool,
    fallbackUrl: PropTypes.string,
    onClick: PropTypes.func.isRequired
};
