import socialAliases from '../../../social_aliases';

export default function prepareProps(props) {
    const {account, avatarSettings, isDefault, fallbackUrl, onClick, isSuggested} = props;
    const {avatarId, login, displayName, hasSocial, hasPlus, mail, defaultEmail, socialProvider, uid} = account;
    const {host, pathname} = avatarSettings;
    const avatarStyle = {
        backgroundImage: `url("https://${host}${pathname
            .replace('%uid%', avatarId)
            .replace('%size%', '200')
            .replace('%login%', login)}")`
    };
    const displayLogin = hasSocial ? socialAliases[socialProvider] : mail || defaultEmail || '';
    const isDefaultAvatar = avatarId === '0/0-0';

    return {
        fallbackUrl,
        socialProvider,
        avatarStyle: isDefaultAvatar ? null : avatarStyle,
        displayName,
        displayLogin,
        isDefault,
        hasSocial,
        hasPlus,
        onClick,
        uid,
        isSuggested,
        isDefaultAvatar
    };
}
