import './AddAccountButton.styl';
import React, {Component} from 'react';
import {bindActionCreators} from 'redux';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {updateLoginValue, setLoginError} from '../../../actions';
import switchToModeAddingAccount from '../../../actions/switchToModeAddingAccount';
import changeNativeInputValue from '../../../actions/changeNativeInputValue';
import {hasExp} from '@blocks/selectors';
import metrika from '@blocks/metrics';

const b = cn('AddAccountButton');

class AddAccountButton extends Component {
    constructor(props) {
        super(props);

        this.handleClick = this.handleClick.bind(this);
    }

    handleClick(event) {
        const {switchToModeAddingAccount, updateLoginValue, setLoginError, changeNativeInputValue} = this.props;

        event.preventDefault();

        metrika.send('войти в другой аккаунт');
        updateLoginValue('');
        changeNativeInputValue('login', '');
        setLoginError(null);
        switchToModeAddingAccount();
    }

    render() {
        const {addUserUrl, useNewSuggestByPhone} = this.props;

        return (
            <div className={b('wrapper', {isNewSuggest: useNewSuggestByPhone})}>
                <a href={addUserUrl} onClick={this.handleClick} className={b()} data-t='account-list-item-add'>
                    <span className={b('icon')} />
                    <span className={b('text')}>{i18n('_AUTH_.switch_account')}</span>
                </a>
            </div>
        );
    }

    static mapStateToProps(state) {
        const {
            common: {addUserUrl}
        } = state;

        return {
            addUserUrl,
            useNewSuggestByPhone: hasExp(state, 'use-new-suggest-by-phone')
        };
    }

    static mapDispatchToProps(dispatch) {
        const actionCreators = {
            switchToModeAddingAccount,
            updateLoginValue,
            setLoginError,
            changeNativeInputValue
        };

        return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
    }
}

AddAccountButton.propTypes = {
    switchToModeAddingAccount: PropTypes.func.isRequired,
    updateLoginValue: PropTypes.func.isRequired,
    changeNativeInputValue: PropTypes.func.isRequired,
    setLoginError: PropTypes.func.isRequired,
    addUserUrl: PropTypes.string.isRequired,
    useNewSuggestByPhone: PropTypes.bool
};

export default connect(AddAccountButton.mapStateToProps, AddAccountButton.mapDispatchToProps)(AddAccountButton);
