import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import {AccountListItem} from '../AccountListItem/AccountListItem.jsx';
import metrika from '@blocks/metrics';

class AuthorizedAccountListItem extends Component {
    handleClick = (event) => {
        const {account, changeActiveAccount} = this.props;

        event.preventDefault();

        metrika.send('переключение current');
        changeActiveAccount(account.uid);
    };

    render() {
        const {account, avatarSettings, fallbackUrl} = this.props;

        if (!account) {
            return null;
        }

        return (
            <AccountListItem
                account={account}
                avatarSettings={avatarSettings}
                fallbackUrl={fallbackUrl}
                onClick={this.handleClick}
                isDefault={false}
            />
        );
    }
}

AuthorizedAccountListItem.propTypes = {
    avatarSettings: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }).isRequired,
    fallbackUrl: PropTypes.string.isRequired,
    changeActiveAccount: PropTypes.func.isRequired,
    account: PropTypes.shape({
        uid: PropTypes.string
    })
};

export default connect(mapStateToProps, mapDispatchToProps)(AuthorizedAccountListItem);
