import './ContextMenu.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Popup} from '@components/Popup';
import {Icon} from '@components/Icon';
import metrics from '@blocks/metrics';
import {FORGET_ACCOUNT, LOGOUT_ACCOUNT, SHOW_SUGGEST_LIST} from '@blocks/authv2/metrics_constants';

const b = cn('ContextMenu');

export class ContextMenu extends React.PureComponent {
    logout = (event) => {
        event.preventDefault();
        const {uid, logoutAccount} = this.props;

        logoutAccount(uid);
        metrics.send([SHOW_SUGGEST_LIST, LOGOUT_ACCOUNT]);
    };

    logoutAndForget = (event) => {
        event.preventDefault();
        const {uid, logoutAndForget} = this.props;

        logoutAndForget(uid);
        metrics.send([SHOW_SUGGEST_LIST, FORGET_ACCOUNT]);
    };

    forget = (event) => {
        event.preventDefault();
        const {uid, forgetAccount} = this.props;

        forgetAccount(uid);

        metrics.send([SHOW_SUGGEST_LIST, FORGET_ACCOUNT]);
    };

    render() {
        const {anchor, visible, clearContextMenuState, isMobile, type, useNewSuggestByPhone} = this.props;

        return (
            <Popup
                target='anchor'
                visible={visible}
                anchor={anchor}
                directions={['bottom-center', 'left-center']}
                onClose={clearContextMenuState}
                onClick={clearContextMenuState}
                mode={isMobile ? 'blind' : ''}
                mainOffset={isMobile ? 0 : -10}
                dataT='context-menu'
            >
                <div className={b({isNewSuggest: useNewSuggestByPhone})}>
                    {type === 'logout' && (
                        <>
                            <button className={b('button')} onClick={this.logout}>
                                <Icon type='exit' size='s' />
                                <span className={b('buttonName')}>{i18n('_AUTH_.logout_account_mobile')}</span>
                            </button>
                            <button className={b('button')} onClick={this.logoutAndForget}>
                                <Icon type='trash' size='s' />
                                <span className={b('buttonName')}>
                                    {i18n('_AUTH_.logout_and_forget_account_mobile')}
                                </span>
                            </button>
                        </>
                    )}

                    {type === 'forget' && (
                        <button className={b('button')} onClick={this.forget}>
                            <Icon type='trash' size='s' />
                            <span className={b('buttonName')}>{i18n('_AUTH_.forget_account_mobile')}</span>
                        </button>
                    )}
                </div>
            </Popup>
        );
    }
}

ContextMenu.propTypes = {
    uid: PropTypes.string.isRequired,
    anchor: PropTypes.object,
    visible: PropTypes.bool.isRequired,
    isMobile: PropTypes.bool.isRequired,
    clearContextMenuState: PropTypes.func.isRequired,
    logoutAccount: PropTypes.func.isRequired,
    logoutAndForget: PropTypes.func.isRequired,
    forgetAccount: PropTypes.func.isRequired,
    type: PropTypes.oneOf(['forget', 'logout']).isRequired,
    useNewSuggestByPhone: PropTypes.bool
};
