import {connect} from 'react-redux';
import {ContextMenu} from './ContextMenu.jsx';
import {clearContextMenuState} from '@blocks/authv2/actions';
import logoutAccount from '@blocks/authv2/actions/logoutAccount';
import logoutAndForget from '@blocks/authv2/actions/logoutAndForget';
import forgetAccount from '@blocks/authv2/actions/forgetAccount';
import {hasExp, isMobile} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {contextMenu = {}} = state;

    return {...contextMenu, isMobile: isMobile(state), useNewSuggestByPhone: hasExp(state, 'use-new-suggest-by-phone')};
};

const mapDispatchToProps = {
    clearContextMenuState,
    logoutAccount,
    logoutAndForget,
    forgetAccount
};

const ConnectedContextMenu = connect(mapStateToProps, mapDispatchToProps)(ContextMenu);

export {ConnectedContextMenu as ContextMenu};
