import './ContextMenuButton.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Icon} from '@components/Icon';

const b = cn('ContextMenuButton');

export const ContextMenuButton = ({showContextMenu, uid, type}) => {
    const ref = React.createRef();

    return (
        <button
            aria-label={i18n('_AUTH_.accountList.ariaLabel.moreActions')}
            className={b()}
            data-t='account-list-item-menu'
            ref={ref}
            onClick={() => showContextMenu({uid, type, anchor: ref})}
        >
            <Icon type='dots' size='s' withHover={true} fillParent={true} />
        </button>
    );
};

ContextMenuButton.propTypes = {
    uid: PropTypes.string.isRequired,
    showContextMenu: PropTypes.func.isRequired,
    type: PropTypes.oneOf(['forget', 'logout'])
};
