import {connect} from 'react-redux';
import {ContextMenuButton} from './ContextMenuButton.jsx';
import {
    setProccessedAccountUid,
    toggleContextMenuVisibility,
    setContextMenuAnchor,
    setContextMenuType
} from '@blocks/authv2/actions';

const mapDispatchToProps = {
    showContextMenu: ({uid, type, anchor}) => (dispatch) => {
        dispatch(setProccessedAccountUid(uid));
        dispatch(setContextMenuAnchor(anchor));
        dispatch(setContextMenuType(type));
        dispatch(toggleContextMenuVisibility(true));
    }
};

const ConnectedContextMenuButton = connect(null, mapDispatchToProps)(ContextMenuButton);

export {ConnectedContextMenuButton as ContextMenuButton};
