import formatAccountListUrl from '../../../utils/formatAccountListUrl';

export default function mapStateToProps(state, ownProps) {
    const {
        settings: {avatar: avatarSettings},
        common: {embeddedauth_url: embeddedAuthUrl, retpath, origin, yu}
    } = state;
    const {
        account: {uid}
    } = ownProps;

    const fallbackUrl = formatAccountListUrl({
        action: 'retpath',
        embeddedAuthUrl,
        retpath,
        yu,
        origin,
        uid
    });

    return {
        avatarSettings,
        fallbackUrl
    };
}
