import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import {AccountListItem} from '../AccountListItem/AccountListItem.jsx';

class InvalidAccountListItem extends Component {
    handleClick = (event) => {
        const {account, editUrl, loginSuggestedAccount, domikIsLoading, setupBackPane} = this.props;

        event.preventDefault();

        domikIsLoading(true);
        setupBackPane(editUrl);
        loginSuggestedAccount(account);
    };

    render() {
        const {account, avatarSettings, fallbackUrl} = this.props;

        if (!account) {
            return null;
        }

        return (
            <AccountListItem
                account={account}
                avatarSettings={avatarSettings}
                fallbackUrl={fallbackUrl}
                onClick={this.handleClick}
                isDefault={false}
            />
        );
    }
}

InvalidAccountListItem.propTypes = {
    isTouch: PropTypes.bool.isRequired,
    avatarSettings: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }).isRequired,
    editUrl: PropTypes.string.isRequired,
    fallbackUrl: PropTypes.string.isRequired,
    logoutAccount: PropTypes.func.isRequired,
    loginSuggestedAccount: PropTypes.func.isRequired,
    domikIsLoading: PropTypes.func.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    changeMobileMenuVisibility: PropTypes.func.isRequired,
    changeMobileMenuType: PropTypes.func.isRequired,
    setProccessedAccountUid: PropTypes.func.isRequired,
    account: PropTypes.shape({
        uid: PropTypes.string
    }).isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(InvalidAccountListItem);
