import formatAccountListUrl from '../../../utils/formatAccountListUrl';

export default function mapStateToProps(state, ownProps) {
    const {
        settings: {avatar: avatarSettings},
        common: {embeddedauth_url: embeddedAuthUrl, retpath, yu, origin, editUrl}
    } = state;
    const {
        account: {uid, login}
    } = ownProps;

    const fallbackUrl = formatAccountListUrl({
        action: 'login',
        embeddedAuthUrl,
        retpath,
        yu,
        uid,
        origin,
        login
    });

    return {
        avatarSettings,
        fallbackUrl,
        editUrl
    };
}
