import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import {AccountListItem} from '../AccountListItem/AccountListItem.jsx';
import metrika from '@blocks/metrics';

class SuggestedAccountListItem extends Component {
    handleClick = (event) => {
        const {account, editUrl, loginSuggestedAccount, domikIsLoading, setupBackPane} = this.props;

        event.preventDefault();

        metrika.send('выбор из кука-lah');
        domikIsLoading(true);
        setupBackPane(editUrl);
        loginSuggestedAccount(account);
    };

    render() {
        const {account, avatarSettings, fallbackUrl} = this.props;

        if (!account) {
            return null;
        }

        return (
            <AccountListItem
                account={account}
                avatarSettings={avatarSettings}
                fallbackUrl={fallbackUrl}
                onClick={this.handleClick}
                isDefault={false}
                isSuggested={true}
            />
        );
    }
}

SuggestedAccountListItem.propTypes = {
    avatarSettings: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }).isRequired,
    editUrl: PropTypes.string.isRequired,
    fallbackUrl: PropTypes.string.isRequired,
    loginSuggestedAccount: PropTypes.func.isRequired,
    forgetAccount: PropTypes.func,
    domikIsLoading: PropTypes.func.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    changeMobileMenuVisibility: PropTypes.func,
    changeMobileMenuType: PropTypes.func,
    setProccessedAccountUid: PropTypes.func,
    account: PropTypes.shape({
        uid: PropTypes.string
    }).isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(SuggestedAccountListItem);
