import formatAccountListUrl from '../../../utils/formatAccountListUrl';

export default function mapStateToProps(state, ownProps) {
    const {
        settings: {avatar: avatarSettings},
        common: {embeddedauth_url: embeddedAuthUrl, retpath, yu, origin, editUrl}
    } = state;
    const {
        account: {uid}
    } = ownProps;

    const fallbackUrl = formatAccountListUrl({
        action: 'switchTo',
        embeddedAuthUrl,
        retpath,
        yu,
        origin,
        uid
    });

    return {
        fallbackUrl,
        avatarSettings,
        editUrl
    };
}
