import filter from 'lodash/filter';
import {hasExp} from '@blocks/selectors';

const sortByPlus = (accounts) => accounts.sort((acc1, acc2) => (acc2.hasPlus ? 1 : 0) - (acc1.hasPlus ? 1 : 0));

export default function mapStateToProps(state) {
    const {
        auth: {unitedAccounts, authorizedAccountsDefaultUid: defaultUid},
        customs: {allowScholar}
    } = state;

    let accounts = filter(unitedAccounts, (o) => o.uid !== '000000');

    if (!allowScholar) {
        accounts = filter(unitedAccounts, (account) => !account.isScholar);
    }

    const authorizedAccounts = sortByPlus(filter(accounts, {status: 'VALID'}));
    const defaultAccount = filter(authorizedAccounts, (o) => o.uid === defaultUid)[0];
    const unAuthorizedAccounts = filter(accounts, (o) => o.status !== 'VALID');
    const suggestedAccounts = sortByPlus(
        filter(unAuthorizedAccounts, (o) => typeof o.allowed_auth_methods !== 'undefined')
    );
    const invalidAccounts = sortByPlus(
        filter(unAuthorizedAccounts, (o) => typeof o.allowed_auth_methods === 'undefined')
    );
    const hasUnauthorizedAccounts = Boolean(suggestedAccounts.length || invalidAccounts.length);
    const isSessionOverflow = Boolean(authorizedAccounts.length >= 15);

    return {
        authorizedAccounts,
        defaultAccount,
        suggestedAccounts,
        invalidAccounts,
        hasUnauthorizedAccounts,
        isSessionOverflow,
        useNewSuggestByPhone: hasExp(state, 'use-new-suggest-by-phone')
    };
}
