import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import Avatar from '../../../avatar-registration/components/Avatar/Avatar.jsx';
import {setupMode} from '../../actions';
import skipAdditionalData from '../../actions/skipAdditionalData';
import sendAvatarMetrics from '../../../avatar-registration/utils/sendAvatarMetrics';
import api from '@blocks/api';

const METRICS_DATA = {
    prefix: 'auth',
    description: 'Дозапрос аватара в домике'
};

class AddAvatar extends Component {
    constructor(props) {
        super(props);

        this.handleSkip = this.handleSkip.bind(this);
        this.sendStat = this.sendStat.bind(this);
    }

    componentDidMount() {
        const {dispatch} = this.props;

        dispatch(setupMode('addAvatar'));
    }

    componentDidUpdate(prevProps) {
        const {trackId} = this.props;

        if (trackId && prevProps.trackId !== trackId) {
            this.sendStat({
                trackId
            });
        }
    }

    handleSkip() {
        sendAvatarMetrics('skip', METRICS_DATA);
        this.props.dispatch(skipAdditionalData());
    }

    sendStat(opts) {
        const {trackId} = opts;

        api.writeStatbox({
            mode: 'domik_ask_avatar',
            track_id: trackId,
            action: 'opened'
        });
    }

    render() {
        return (
            <Fragment>
                <Avatar onSkip={this.handleSkip} metricsInfo={METRICS_DATA} skipDescription={true} />
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(AddAvatar);

AddAvatar.propTypes = {
    addUserUrl: PropTypes.string.isRequired,
    resultRetpath: PropTypes.string.isRequired,
    trackId: PropTypes.string,
    dispatch: PropTypes.func
};
