import {isAndroidAm} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        additionalDataRequest: {
            phone,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors
        }
    } = state;

    const squashedPhoneNumber = phone.number.replace(/ /gi, '&nbsp;');
    const popupTitle = i18n('_AUTH_.phone.enter-confirmation-code.title.v2').replace(
        '%1',
        `<b>${squashedPhoneNumber}</b>`
    );

    return {
        confirmationCode,
        isConfirmationCodeSent,
        isCaptchaRequired,
        action,
        denyResendUntil,
        errors,
        popupTitle,
        phoneNumber: phone.number,
        phoneId: phone.id,
        isWithCodeFormatExp: !isAndroidAm(state)
    };
}
