import React from 'react';
import PropTypes from 'prop-types';
import metrics from '@blocks/metrics';

export class AmErrorBoundary extends React.Component {
    componentDidCatch() {
        metrics.send('Креш в вебам');

        if (this.props.finishErrorUrl) {
            window.location = this.props.finishErrorUrl;
        }
    }

    render() {
        return this.props.children;
    }
}

AmErrorBoundary.propTypes = {
    finishErrorUrl: PropTypes.string.isRequired,
    children: PropTypes.node
};
