export default function mapStateToProps(state) {
    const {
        auth: {
            unitedAccounts: accounts,
            form = {},
            isCaptchaRequired,
            magicError,
            loginError,
            passwordError,
            loading: isLoading,
            captchaError
        },
        mobileMenu: {isShowMobileMenu},
        pagePopup: {isShowPagePopup},
        additionalDataRequest: {errors: additionalDataErrors}
    } = state;

    return {
        isCanRegister: Boolean(form.isCanRegister),
        isLoading,
        accounts,
        isCaptchaRequired,
        magicError,
        loginError,
        passwordError,
        captchaError,
        isShowMobileMenu,
        isShowPagePopup,
        additionalDataErrors
    };
}
