import './AuthBySMSButton.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import metrics from '@blocks/metrics';
import {Button} from '@components/Button';
import {Popup} from '@components/Popup';
import {CLICK_AUTH_SMS_BUTTON, SHOW_AUTH_SMS_BUTTON} from '@blocks/authv2/metrics_constants';
import {Icon} from '@components/Icon';

const b = cn('AuthBySMSButton');

const HIDE_TIMEOUT = 1000 * 10;

class AuthBySMSButton extends React.PureComponent {
    buttonRef = React.createRef();

    constructor() {
        super();

        this.state = {isNotAvailable: false};
    }

    componentDidMount() {
        metrics.send([SHOW_AUTH_SMS_BUTTON]);
    }

    componentDidUpdate(prevProps) {
        const {error} = this.props;

        if (error && prevProps.error !== error) {
            this.hideButton();
        }
    }

    hideButton = () => {
        const {setAuthBySMSState} = this.props;

        setTimeout(() => this.setState({isNotAvailable: true}, () => setAuthBySMSState({error: ''})), HIDE_TIMEOUT);
    };

    onClick = () => {
        const {submitAuthBySMS} = this.props;

        metrics.send([CLICK_AUTH_SMS_BUTTON]);
        submitAuthBySMS();
    };

    render() {
        const {error, isNewTextExp} = this.props;
        const {isNotAvailable} = this.state;

        if (isNotAvailable) {
            return null;
        }

        return (
            <>
                <Button
                    size='l'
                    view='default'
                    type='button'
                    width='max'
                    controlRef={this.buttonRef}
                    onClick={this.onClick}
                    dataT='auth-by-sms'
                >
                    <Icon size='s' place='button' type='message' />
                    {isNewTextExp ? i18n('_AUTH_.AuthSMS.btn.getcode') : i18n('_AUTH_.AuthSMS.btn')}
                </Button>
                <Popup
                    visible={Boolean(error)}
                    view='black'
                    target='anchor'
                    anchor={this.buttonRef}
                    directions={['bottom-center']}
                    style={{maxWidth: '350px'}}
                    keepMounted={false}
                >
                    <div className={b('error')} dangerouslySetInnerHTML={{__html: error}} />
                </Popup>
            </>
        );
    }
}

AuthBySMSButton.propTypes = {
    submitAuthBySMS: PropTypes.func.isRequired,
    setAuthBySMSState: PropTypes.func.isRequired,
    error: PropTypes.string,
    isNewTextExp: PropTypes.bool
};

export {AuthBySMSButton};
