import {connect} from 'react-redux';
import {submitAuthBySMS, setAuthBySMSState} from '@blocks/authv2/actions/authBySMS';
import errorTexts from '@blocks/authv2/errors';
import {AuthBySMSButton} from './AuthBySMSButton.jsx';
import {hasExp} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {auth = {}} = state;
    const {authBySMS = {}} = auth;
    const {error} = authBySMS;

    return {
        error: error && (errorTexts[error] || errorTexts.global),
        isNewTextExp: hasExp(state, 'sms-auth-on-text1')
    };
};

const mapDispatchToProps = {
    submitAuthBySMS,
    setAuthBySMSState
};

const ConnectedAuthBySMSButton = connect(mapStateToProps, mapDispatchToProps)(AuthBySMSButton);

export {ConnectedAuthBySMSButton as AuthBySMSButton};
