import './AuthConfirmationBySMSPopup.styl';
import React from 'react';
import PropTypes from 'prop-types';
import PagePopupContent from '@blocks/authv2/components/PagePopupContent/PagePopupContent.jsx';
import Form from '@blocks/authv2/components/Form/Form.jsx';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';

class AuthConfirmationBySMSPopup extends React.PureComponent {
    componentDidMount() {
        if (this.props.onMount) {
            this.props.onMount();
        }
    }

    render() {
        const {commitAuthBySMS, submitAuthBySMS} = this.props;

        return (
            <PagePopupContent cls='AuthConfirmationBySMSPopup' dataT='auth-confirmation-by-sms-popup'>
                <Form withoutOffset={true} cls='AuthConfirmationBySMSForm' dataT='auth-confirmation-by-sms-popup'>
                    <PhoneConfirmation onConfirm={commitAuthBySMS} onRetry={submitAuthBySMS} place='auth' />
                </Form>
            </PagePopupContent>
        );
    }
}

AuthConfirmationBySMSPopup.propTypes = {
    commitAuthBySMS: PropTypes.func.isRequired,
    submitAuthBySMS: PropTypes.func.isRequired,
    onMount: PropTypes.func.isRequired
};

export {AuthConfirmationBySMSPopup};
