import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {Title} from '@components/Title';

const AuthLetterAccountConfirmed = ({isAuthConfirmed, login, deviceInfo, staticPath, retpath, isRegister}) => {
    let deviceText = (deviceInfo && i18n('_AUTH_.MagicLink.success')) || i18n('_AUTH_.MagicLink.success_no_device');

    deviceText = deviceText.replace('%login', login).replace('%device', deviceInfo);

    if (isRegister) {
        deviceText = i18n('_AUTH_.MagicLink.success_no_device_register');
    }

    if (isAuthConfirmed) {
        return (
            <div>
                <Title>
                    <span dangerouslySetInnerHTML={{__html: deviceText}} />
                </Title>

                {!retpath && (
                    <React.Fragment>
                        <div className='passp-letter-info-picture'>
                            <img src={`${staticPath}/i/magic-letter/magic.svg`} alt='magic pic' role='presentation' />
                        </div>
                        <p>{i18n('_AUTH_.MagicLink.close_text')}</p>
                    </React.Fragment>
                )}

                {retpath && (
                    <Button
                        type='link'
                        url={retpath}
                        text={i18n('_AUTH_.MagicLink.button.link_back_to_app')}
                        view='action'
                        width='max'
                        size='l'
                    />
                )}
            </div>
        );
    }

    return null;
};

AuthLetterAccountConfirmed.propTypes = {
    isAuthConfirmed: PropTypes.bool.isRequired,
    isRegister: PropTypes.bool.isRequired,
    deviceInfo: PropTypes.string.isRequired,
    login: PropTypes.string.isRequired,
    retpath: PropTypes.string,
    staticPath: PropTypes.string.isRequired
};

export default AuthLetterAccountConfirmed;
