import './AuthLetterButton.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {cn} from '@bem-react/classname';
import resizeAuthScreen from '../../utils/resizeAuthScreen';
import mapStateToProps from './mapStateToProps';
import sendAuthLetter from '../../actions/sendAuthLetter';
import checkCaptcha from '../../actions/checkCaptcha';
import checkAuthLetterStatus from '../../actions/checkAuthLetterStatus';
import {changePagePopupVisibility, changePagePopupType, setAuthMailError} from '../../actions';
import AuthLetterCaptcha from '../AuthLetterCaptcha/AuthLetterCaptcha.jsx';
import {SHOW_AUTH_LETTER_BUTTON, CLICK_AUTH_LETTER_BUTTON} from '../../metrics_constants';
import metrics from '../../../metrics';
import {Button} from '@components/Button';
import {Popup} from '@components/Popup';
import {Icon} from '@components/Icon';

const b = cn('AuthLetterButton');

export class AuthLetterButton extends Component {
    buttonRef = React.createRef();

    constructor(props) {
        super(props);

        this.handleAuthLetter = this.handleAuthLetter.bind(this);
        this.handleCaptcha = this.handleCaptcha.bind(this);
    }

    componentDidMount() {
        metrics.send([SHOW_AUTH_LETTER_BUTTON]);
    }

    componentWillUnmount() {
        this.props.dispatch(setAuthMailError(''));
        resizeAuthScreen();
    }

    componentDidUpdate(prevProps) {
        if (!prevProps.shouldErrorDisappear && this.props.shouldErrorDisappear) {
            resizeAuthScreen();
            setTimeout(() => {
                this.props.dispatch(setAuthMailError(''));
            }, 6000);
        }
    }

    handleAuthLetter() {
        const {isAuthMailConfirmationVisible, isAuthLetterStatusChecking, dispatch} = this.props;

        if (isAuthLetterStatusChecking && !isAuthMailConfirmationVisible) {
            dispatch(changePagePopupVisibility(true));
            dispatch(changePagePopupType('authLetter'));
            return;
        }

        dispatch(sendAuthLetter(true));
        metrics.send([CLICK_AUTH_LETTER_BUTTON]);
    }

    handleCaptcha(event) {
        event.preventDefault();
        this.props.dispatch(checkCaptcha({action: checkAuthLetterStatus}));
    }

    render() {
        const {isAuthMailSent, isCaptchaRequired, email, error, buttonText, descriptionText} = this.props;

        if (isCaptchaRequired) {
            return <AuthLetterCaptcha handleCaptcha={this.handleCaptcha} />;
        }

        return (
            <>
                <Button
                    size='l'
                    view='default'
                    type='button'
                    width='max'
                    controlRef={this.buttonRef}
                    onClick={this.handleAuthLetter}
                    dataT='auth-letter'
                >
                    <Icon size='s' place='button' type='letter' />
                    {buttonText}
                </Button>
                <Popup
                    visible={Boolean(error && !isCaptchaRequired)}
                    view='black'
                    target='anchor'
                    anchor={this.buttonRef}
                    directions={['bottom-center']}
                    style={{maxWidth: '350px'}}
                    keepMounted={false}
                >
                    <div className={b('error')}>{error}</div>
                </Popup>
                {!isAuthMailSent && email && (
                    <div className={b('description')} dangerouslySetInnerHTML={{__html: descriptionText}} />
                )}
            </>
        );
    }
}

export default connect(mapStateToProps)(AuthLetterButton);

AuthLetterButton.propTypes = {
    isAuthMailConfirmationVisible: PropTypes.bool,
    isAuthMailSent: PropTypes.bool,
    isAuthLetterStatusChecking: PropTypes.bool,
    isCaptchaRequired: PropTypes.bool,
    email: PropTypes.string.isRequired,
    error: PropTypes.string,
    shouldErrorDisappear: PropTypes.bool,
    buttonText: PropTypes.string,
    descriptionText: PropTypes.string,
    dispatch: PropTypes.func
};
