import authWithLetterErrors from '../AuthWithLetterInfo/authWithLetterErrors';
import errors from '../../errors';

export default function mapStateToProps(state) {
    const {
        mailAuth: {
            isAuthMailConfirmationVisible,
            isUpdatedAuthLetterStatus,
            isAuthMailSent,
            isAuthCancelled,
            mailAuthError,
            mailAuthExperiment
        },
        auth: {processedAccount}
    } = state;
    const {email = ''} = processedAccount || {};
    const errorTexts = Object.assign({}, errors, authWithLetterErrors);
    const shouldErrorDisappear = mailAuthError === 'magic_link.invalidated';
    const error = mailAuthError && (errorTexts[mailAuthError] || errorTexts.global);
    const isCaptchaRequired = mailAuthError === 'captcha.required';
    const isAuthLetterStatusChecking = isAuthMailSent && !isAuthCancelled;
    const buttonText = getMailAuthButtonText(mailAuthExperiment, isAuthLetterStatusChecking);
    const descriptionText = getMailAuthDescription(mailAuthExperiment, email);

    return {
        isAuthMailConfirmationVisible,
        isUpdatedAuthLetterStatus,
        isAuthMailSent,
        isAuthCancelled,
        isAuthLetterStatusChecking,
        isCaptchaRequired,
        error,
        shouldErrorDisappear,
        email,
        buttonText,
        descriptionText
    };
}

function getMailAuthButtonText(experiment, isStatusChecking) {
    if (isStatusChecking) {
        return i18n('_AUTH_.MagicLink.status');
    }

    const buttonTexts = {
        magic_link_exp: i18n('_AUTH_.MagicLink.btn'),
        magic_link_exp_t1: i18n('_AUTH_.MagicLink.btn'),
        magic_link_exp_t2: i18n('_AUTH_.MagicLink.btn.v2'),
        magic_link_exp_t3: i18n('_AUTH_.MagicLink.btn.v2'),
        magic_link_exp_t4: i18n('_AUTH_.MagicLink.btn.v3')
    };

    return buttonTexts[experiment] || buttonTexts.magic_link_exp;
}

function getMailAuthDescription(experiment = 'magic_link_exp', email) {
    const descriptions = {
        magic_link_exp: i18n('_AUTH_.MagicLink.send.letter'),
        magic_link_exp_t1: i18n('_AUTH_.MagicLink.send.letter.v2'),
        magic_link_exp_t2: i18n('_AUTH_.MagicLink.send.letter.v3'),
        magic_link_exp_t3: i18n('_AUTH_.MagicLink.send.letter.v4'),
        magic_link_exp_t4: i18n('_AUTH_.MagicLink.send.letter.v5')
    };

    return (descriptions[experiment] && descriptions[experiment].replace('%s', email)) || descriptions.magic_link_exp;
}
