import React from 'react';
import PropTypes from 'prop-types';
import CaptchaField from '../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';

const AuthLetterCaptcha = ({handleCaptcha}) => (
    <div className='al-captcha__wrapper'>
        <form onSubmit={handleCaptcha} method='post'>
            <CaptchaField />
            <Button type='submit' text={i18n('_AUTH_.Captcha_submit')} view='action' size='l' width='max' />
        </form>
    </div>
);

export default AuthLetterCaptcha;

AuthLetterCaptcha.propTypes = {
    handleCaptcha: PropTypes.func.isRequired
};
