import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';

class AuthLetterImageCode extends Component {
    render() {
        const {code, deviceInfo, showDescription, staticPath, text} = this.props;
        const actualDevice = deviceInfo || '';

        if (!code) {
            return null;
        }

        return (
            <div>
                {showDescription && (
                    <p className='al-send-popup__code-descr'>
                        {i18n('_AUTH_.MagicLink.confirmation_text1').replace('%device', actualDevice)}
                    </p>
                )}
                <ul className='al-send-popup__code'>
                    {code.map((d, index) => (
                        <li className='popup__code-item' key={index}>
                            <img
                                className='popup__code-item-img'
                                src={`${staticPath}/i/magic-letter/${d}.png`}
                                alt='magic link code image'
                            />
                        </li>
                    ))}
                </ul>
                <div className='al-send-popup__code-descr' dangerouslySetInnerHTML={{__html: text}} />
            </div>
        );
    }
}

export default connect(mapStateToProps)(AuthLetterImageCode);

AuthLetterImageCode.propTypes = {
    text: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    code: PropTypes.array.isRequired,
    deviceInfo: PropTypes.string,
    showDescription: PropTypes.bool
};
