import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import AuthLetterImageCode from '../AuthLetterImageCode/AuthLetterImageCode.jsx';
import invalidateAuthFromLetter from '../../actions/invalidateAuthFromLetter';
import CheckAuthWithMailStatus from '../CheckAuthWithMailStatus/CheckAuthWithMailStatus.jsx';
import {hasExp} from '@blocks/selectors';
import PagePopupContent from '@blocks/authv2/components/PagePopupContent/PagePopupContent';
import {Title} from '@components/Title';
import {Link} from '@components/Link';

class AuthLetterPopup extends PureComponent {
    constructor(props) {
        super(props);

        this.handleCloseClick = this.handleCloseClick.bind(this);
    }

    handleCloseClick() {
        const {dispatch, closePopup} = this.props;

        closePopup();
        dispatch(invalidateAuthFromLetter());
    }

    render() {
        const {email, isMagicLinkOnly} = this.props;
        const sentMessage = i18n('_AUTH_.MagicLink.letter.send').replace('%s', email);

        return (
            <PagePopupContent dataT='auth-letter'>
                <Title>
                    <span dangerouslySetInnerHTML={{__html: sentMessage}} />
                </Title>
                <AuthLetterImageCode text={i18n('_AUTH_.MagicLink.confirmation_text')} />
                {!isMagicLinkOnly && (
                    <Link pseudo={true} onClick={this.handleCloseClick}>
                        {i18n('_AUTH_.other_enter_method')}
                    </Link>
                )}
                <CheckAuthWithMailStatus />
            </PagePopupContent>
        );
    }

    static mapStateToProps(state) {
        const {
            auth: {processedAccount}
        } = state;
        const {email = '', allowed_auth_methods: allowedAuthMethods = []} = processedAccount || {};
        const isMagicLinkOnly =
            (allowedAuthMethods.length === 1 && allowedAuthMethods[0] === 'magic_link') ||
            (allowedAuthMethods.includes('sms_code') &&
                allowedAuthMethods.includes('magic_link') &&
                allowedAuthMethods.length === 2 &&
                !hasExp(state, 'sms-auth-on'));

        return {
            email,
            isMagicLinkOnly
        };
    }
}

export default connect(AuthLetterPopup.mapStateToProps)(AuthLetterPopup);

AuthLetterPopup.propTypes = {
    email: PropTypes.string.isRequired,
    isMagicLinkOnly: PropTypes.bool.isRequired,
    closePopup: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired
};
