import React from 'react';
import PropTypes from 'prop-types';

const AuthWithLetterCancellation = ({isAuthCancelled}) => {
    if (isAuthCancelled) {
        return (
            <div>
                <p>{i18n('_AUTH_.MagicLink.cancellation')}</p>
                <p>{i18n('_AUTH_.MagicLink.close_text')}</p>
            </div>
        );
    }
    return null;
};

AuthWithLetterCancellation.propTypes = {
    isAuthCancelled: PropTypes.bool
};

export default AuthWithLetterCancellation;
