import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './AuthWebviewCloser.styl';

const b = cn('AuthWebviewCloser');

export const AuthWebviewCloser = ({showCloser, backpath, isFullScreen}) =>
    showCloser && <a data-t='webview-closer' className={b({isFullScreen})} href={backpath} />;

AuthWebviewCloser.propTypes = {
    backpath: PropTypes.string,
    isFullScreen: PropTypes.bool,
    showCloser: PropTypes.bool
};
