import {connect} from 'react-redux';
import {AuthWebviewCloser as Closer} from './AuthWebviewCloser';

const ORIGINS_TO_SHOW_CLOSER = ['zalogin_app'];

const mapStateToProps = ({
    common: {isWebView = false, backpath = '', origin = ''} = {},
    customs: {showWebviewCloser = false, isFullScreen = false} = {}
}) => ({
    showCloser:
        (backpath && origin && (showWebviewCloser || (isWebView && ORIGINS_TO_SHOW_CLOSER.includes(origin)))) || false,
    isFullScreen,
    backpath
});

export const AuthWebviewCloser = connect(mapStateToProps)(Closer);
