import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import AuthLetterImageCode from '../AuthLetterImageCode/AuthLetterImageCode.jsx';
import {Title} from '@components/Title';

const AuthWithLetterInfo = (props) => {
    if (!props.isInfoRenders) {
        return null;
    }

    let text = i18n('_AUTH_.MagicLink.check_info');

    if (props.isRegister) {
        text = i18n('_AUTH_.MagicLink.check_info_register');
    }

    text = text.replace('%login', props.login);

    return (
        <div>
            <Title>
                <span dangerouslySetInnerHTML={{__html: text}} />
            </Title>

            <AuthLetterImageCode
                staticPath={props.staticPath}
                deviceInfo={props.deviceInfo}
                showDescription={true}
                text={i18n('_AUTH_.MagicLink.btn_confirm_text')}
            />
            <div className={`auth_letter_action-buttons`}>
                <div data-t='cancel-auth' className='auth_letter_action-buttons-item'>
                    <Button
                        onClick={props.denyLetterAuth}
                        type='button'
                        text={i18n('_AUTH_.cancel')}
                        view='pseudo'
                        size='l'
                        width='max'
                    />
                </div>
                <div data-t='confirm-auth' className='auth_letter_action-buttons-item'>
                    <Button
                        onClick={props.confirmLetterAuth}
                        type='button'
                        text={
                            (props.isRegister && i18n('_AUTH_.MagicLink.check_info_register.button_confirm')) ||
                            i18n('_AUTH_.Form.ButtonText.login')
                        }
                        view='action'
                        size='l'
                        width='max'
                    />
                </div>
            </div>
        </div>
    );
};

AuthWithLetterInfo.propTypes = {
    isInfoRenders: PropTypes.bool.isRequired,
    isRegister: PropTypes.bool.isRequired,
    login: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    deviceInfo: PropTypes.string.isRequired,
    denyLetterAuth: PropTypes.func.isRequired,
    confirmLetterAuth: PropTypes.func.isRequired
};

export default AuthWithLetterInfo;
