import errors from '../../errors';

export default function mapStateToProps(state) {
    const {
        settings: {isNoTabletTouch, language, env = {}},
        auth: {
            isCaptchaRequired,
            captchaError,
            form: {captcha_answer: captchaAnswer}
        },
        captcha: {introSound, captchaSound, imageUrl, loading, loadingAudio, playing, type, key},
        am: {isAm = false} = {}
    } = state;

    let fieldError = null;

    if (captchaError) {
        fieldError = errors[captchaError] || errors.global;
    }

    return {
        isNoTabletTouch,
        captchaAnswer,
        isCaptchaRequired,
        lang: language,
        fieldError,
        introSound,
        captchaSound,
        imageUrl,
        loading,
        loadingAudio,
        playing,
        type,
        captchaKey: key,
        isAm,
        env
    };
}
