import React, {useCallback, useEffect} from 'react';
import {useSelector, useDispatch} from 'react-redux';
import {isKeyEnabled2FASelector} from '@blocks/selectors';
import {changePagePopupVisibility} from '@blocks/authv2/actions';
import {authEnableKey2FA} from '@blocks/authv2/actions/authEnableKey2FA';
import {Captcha} from '@screens/Captcha';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';

export const CaptchaPopup = () => {
    const dispatch = useDispatch();
    const isKeyEnabled2FA = useSelector(isKeyEnabled2FASelector);
    const amMode = useSelector((state) => (state.am && state.am.mode) || undefined);

    const onConfirm = useCallback(async () => {
        dispatch(changePagePopupVisibility(false));
        if (isKeyEnabled2FA && ['welcome', 'phoneconfirm'].includes(amMode)) {
            await dispatch(authEnableKey2FA());
        }
    }, [isKeyEnabled2FA, amMode, dispatch]);

    useEffect(() => {
        dispatch(reloadCaptcha());
    }, [dispatch]);

    return <Captcha onConfirmCallback={onConfirm} />;
};
