import {hasExp, isAndroidAm} from '@blocks/selectors';

export default function mapStateToProps(state = {}) {
    const {
        challenge: {errorText, fieldValue, smsTo, isConfirmWithCall, challengeType, isOneStepChallenge},
        customs: {isWhiteLabel = false} = {},
        am: {isAm, appId} = {}
    } = state;
    const isWithCodeFormatExp = !isAndroidAm(state);
    const title = isConfirmWithCall
        ? i18n('_AUTH_.phoneconfirmation.title.call')
        : i18n('_AUTH_.RestoreLogin.enter-confirmation-code.title').replace(
              '%1',
              `<span class="passp-phone-template" dir="ltr">${smsTo || ''}</span>`
          );
    const btnText = isConfirmWithCall ? i18n('_AUTH_.confirmation_call_repeat') : i18n('_AUTH_.code.send-again-link');
    const smsBtnText = isConfirmWithCall
        ? i18n('_AUTH_.RestoreLogin.confirm_by_sms')
        : i18n('_AUTH_.enter-confirmation-code.send-again.v2');
    const hasRoundViewExp = hasExp(state, 'rounded-input-exp');
    const maxFieldLength = isWithCodeFormatExp && !hasRoundViewExp ? 7 : 6;

    return {
        isConfirmWithCall,
        errorText,
        title,
        btnText,
        smsBtnText,
        value: fieldValue,
        maxFieldLength,
        isWhiteLabel,
        isOneStepChallenge,
        hasRoundViewExp,
        isAm,
        appId,
        challengeType
    };
}
