import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';
import {Button} from '@components/Button';
import {
    CHALLENGES_PAGE,
    CHALLENGES_PAGE_PHONE_CALL_SHOW,
    CHALLENGES_PAGE_PHONE_CALL_SUBMIT
} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';

const defaultCssClass = classNames('auth-challenge__call');

class ChallengeWithDictation extends PureComponent {
    componentDidMount() {
        this.buttonRef && this.buttonRef.focus();

        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_PHONE_CALL_SHOW]);
    }

    handleChange = (value) => {
        this.props.updateFieldValue(value);
    };

    handleSubmit = (event) => {
        event.preventDefault();

        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_PHONE_CALL_SUBMIT]);
        this.props.validatePhone();
    };

    render() {
        const {hint, errorText} = this.props;

        return (
            <div className={defaultCssClass()}>
                <div className='auth-challenge-descr'>
                    <p>{i18n('_AUTH_.challenge.phone_confirm')}</p>
                </div>
                <form className={defaultCssClass('form')} onSubmit={this.handleSubmit}>
                    <div className='auth-challenge-form-hint'>
                        {i18n('_AUTH_.challenge.confirmation_number')}
                        <strong>{hint}</strong>
                    </div>

                    <div data-t='challenge_sumbit_phone-confirmation' className='passp-button'>
                        {errorText && (
                            <div className='passp-form-field__error' dangerouslySetInnerHTML={{__html: errorText}} />
                        )}
                        <Button
                            controlRef={(ref) => (this.buttonRef = ref)}
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.confirm_code')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </div>
        );
    }
}

export default ChallengeWithDictation;

ChallengeWithDictation.propTypes = {
    hint: PropTypes.string,
    errorText: PropTypes.string,
    validatePhone: PropTypes.func.isRequired,
    updateFieldValue: PropTypes.func.isRequired
};
