import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';
import {Field} from '@components/Field';
import {Button} from '@components/Button';

import metrics from '@blocks/metrics';
import {CHALLENGES_PAGE, CHALLENGES_PAGE_EMAIL_CODE_SHOW} from '@blocks/authv2/metrics_constants';

const defaultCssClass = classNames('auth-challenge__email');

class ChallengeWithEmailCode extends PureComponent {
    constructor(props) {
        super(props);

        this.fieldOptions = {
            autoCorrect: 'off',
            autoCapitalize: 'off',
            autoComplete: 'off'
        };

        this.fieldLink = {
            onClick: this.sendCodeAgain,
            pseudo: true,
            text: i18n('_AUTH_.phone_send_code_again')
        };
    }

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        const {sendCodeToEmail} = this.props;

        sendCodeToEmail();

        setTimeout(this.focus, 300);
        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_EMAIL_CODE_SHOW]);
    }

    handleChange = (value) => {
        this.props.updateFieldValue(value);
    };

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.confirmEmailCode();
    };

    sendCodeAgain = () => {
        const {sendCodeToEmail} = this.props;

        sendCodeToEmail();
    };

    render() {
        const {value, errorText} = this.props;

        return (
            <div className={defaultCssClass()}>
                <form className={defaultCssClass('form')} onSubmit={this.handleSubmit}>
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.code_from_email_label')}
                        value={value}
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                        name='confirmation-code'
                        type='tel'
                        options={this.fieldOptions}
                        link={this.fieldLink}
                        isShowFieldLink={true}
                        placeholder='12345'
                    />

                    <div data-t='challenge_sumbit_email_code' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </div>
        );
    }
}

export default ChallengeWithEmailCode;

ChallengeWithEmailCode.propTypes = {
    updateFieldValue: PropTypes.func.isRequired,
    confirmEmailCode: PropTypes.func.isRequired,
    value: PropTypes.string,
    hint: PropTypes.array,
    errorText: PropTypes.string,
    errorCode: PropTypes.string,
    sendCodeToEmail: PropTypes.func.isRequired
};
