import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import metrics from '@blocks/metrics';
import {CHALLENGES_PAGE, CHALLENGES_PAGE_PHONE_SHOW} from '@blocks/authv2/metrics_constants';

const defaultCssClass = classNames('auth-challenge__email');

class ChallengeWithPhone extends PureComponent {
    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        setTimeout(this.focus, 300);
        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_PHONE_SHOW]);
    }

    handleChange = (value) => {
        this.props.updateFieldValue(value);
    };

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.passChallenge();
    };

    render() {
        const {value, hint, errorText} = this.props;

        return (
            <div className={defaultCssClass()}>
                <div className='auth-challenge-descr'>
                    <p>{i18n('_AUTH_.challenge.phone-text')}</p>
                </div>
                <form className={defaultCssClass('form')} onSubmit={this.handleSubmit}>
                    {hint && (
                        <div className='auth-challenge-form-hint'>
                            {i18n('_AUTH_.challenge.hint')} <strong>{hint}</strong>
                        </div>
                    )}
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.challenge.phone_label')}
                        value={value}
                        name='phone'
                        type='tel'
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                    />

                    <div data-t='challenge_sumbit_phone' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </div>
        );
    }
}

export default ChallengeWithPhone;

ChallengeWithPhone.propTypes = {
    updateFieldValue: PropTypes.func.isRequired,
    passChallenge: PropTypes.func.isRequired,
    value: PropTypes.string,
    hint: PropTypes.string,
    errorText: PropTypes.string,
    challengeType: PropTypes.string
};
