import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {classNames} from '../../../../utils';
import {Field} from '@components/Field';
import {Button} from '@components/Button';

import metrics from '../../../../metrics';
import {CHALLENGES_PAGE, CHALLENGES_PAGE_QUESTION_SHOW} from '../../../metrics_constants';

const defaultCssClass = classNames('auth-challenge__question');

class ChallengeWithQuestion extends PureComponent {
    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        setTimeout(this.focus, 300);
        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_QUESTION_SHOW]);
    }

    handleChange = (value) => {
        this.props.updateFieldValue(value);
    };

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.passChallenge();
    };

    render() {
        const {value, hint, errorText} = this.props;

        return (
            <div className={defaultCssClass()}>
                <form className={defaultCssClass('form')} onSubmit={this.handleSubmit}>
                    <div className='auth-challenge-form-hint'>
                        <strong>{hint}</strong>
                    </div>
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.field_hint_answer')}
                        value={value}
                        name='question'
                        type='text'
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                    />

                    <div data-t='challenge_sumbit_question' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </div>
        );
    }
}

export default ChallengeWithQuestion;

ChallengeWithQuestion.propTypes = {
    updateFieldValue: PropTypes.func.isRequired,
    passChallenge: PropTypes.func.isRequired,
    value: PropTypes.string,
    hint: PropTypes.string,
    errorText: PropTypes.string
};
