import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {Phone} from '@components/Phone';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';
import Title from '@blocks/authv2/components/Title/Title';

import './BindPhone.styl';

const b = cn('BindPhone');

export class BindPhone extends PureComponent {
    sendCode = (event) => {
        if (event) {
            event.preventDefault();
        }

        this.props.confirmPhone();
    };

    checkCode = () => {
        this.props.checkPhoneCode();
    };

    render() {
        const {status, trackId, authUrl} = this.props;

        if (status === 'code-sent') {
            return (
                <div className={b('content')}>
                    <PhoneConfirmation onConfirm={this.checkCode} onRetry={this.sendCode} />
                </div>
            );
        }

        return (
            <Fragment>
                <Title>{i18n('_AUTH_.bind_phone_title')}</Title>
                <div className={b('form')}>
                    <form method='post' action={authUrl} onSubmit={this.sendCode}>
                        <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                        <Phone name='phone' label={i18n('_AUTH_.field_label_reg-mobile')} view='big-input' size='l' />
                        <div data-t='passp:submit-send-code-btn'>
                            <Button
                                onClick={this.sendCode}
                                text={i18n('_AUTH_.RestoreLogin.next-step')}
                                width='max'
                                size='l'
                            />
                        </div>
                    </form>
                </div>
            </Fragment>
        );
    }
}

BindPhone.propTypes = {
    step: PropTypes.string.isRequired,
    status: PropTypes.string.isRequired,
    confirmPhone: PropTypes.func.isRequired,
    checkPhoneCode: PropTypes.func.isRequired,
    trackId: PropTypes.string,
    authUrl: PropTypes.string
};
