import {connect} from 'react-redux';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getTrackId} from '@blocks/selectors';
import {BindPhone} from './BindPhone.jsx';
import confirmPhone from '@blocks/authv2/actions/forcePasswordChange/confirmPhone';
import checkPhoneCode from '@blocks/authv2/actions/forcePasswordChange/checkPhoneCode';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {step, status},
        common: {authUrl}
    } = state;
    const trackId = getTrackId(state, TRACK_TYPES.COMMON);

    return {
        step,
        status,
        trackId,
        authUrl
    };
};

const mapDispatchToProps = {
    confirmPhone,
    checkPhoneCode
};

const ConnectedBindPhone = connect(mapStateToProps, mapDispatchToProps)(BindPhone);

export {ConnectedBindPhone as BindPhone};
