import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import CaptchaField from '@blocks/authv2/components/CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import {updateChangePasswordStep} from '@blocks/authv2/actions/forcePasswordChange';
import checkCaptcha from '@blocks/authv2/actions/checkCaptcha';
import Title from '@blocks/authv2/components/Title/Title';

export class CaptchaInput extends PureComponent {
    handleSubmit = (event) => {
        const {nextStep} = this.props;

        event.preventDefault();

        this.props.dispatch(checkCaptcha({action: updateChangePasswordStep, actionArguments: [nextStep]}));
    };

    render() {
        const {trackId} = this.props;

        return (
            <Fragment>
                <Title>{i18n('_AUTH_.enter_captcha_label')}</Title>
                <form method='post' className={`passp-normal_margin-form`} onSubmit={this.handleSubmit}>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <CaptchaField isShowCaptcha={true} isCaptchaRequired={true} />
                    <div data-t='submit-captcha-btn'>
                        <Button
                            onClick={this.handleSubmit}
                            text={i18n('_AUTH_.RestoreLogin.next-step')}
                            width='max'
                            size='l'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

CaptchaInput.propTypes = {
    step: PropTypes.string.isRequired,
    nextStep: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    trackId: PropTypes.string
};
