import {connect} from 'react-redux';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getTrackId} from '@blocks/selectors';
import {CaptchaInput} from './CaptchaInput.jsx';

const mapStateToProps = (state = {}) => {
    const {
        changePassword: {step, number, status}
    } = state;
    const getNextStep = () => {
        if (number && status === 'phone-confirmed') {
            return 'password';
        }

        return number ? 'phone' : 'question';
    };

    return {
        step,
        nextStep: getNextStep(),
        trackId: getTrackId(state, TRACK_TYPES.COMMON)
    };
};

const ConnectedCaptchaInput = connect(mapStateToProps)(CaptchaInput);

export {ConnectedCaptchaInput as CaptchaInput};
