import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {PhoneInput} from '@blocks/authv2/components/ChangePassword/PhoneInput';
import {CaptchaInput} from '@blocks/authv2/components/ChangePassword/CaptchaInput';
import {PasswordInput} from '@blocks/authv2/components/ChangePassword/PasswordInput';
import {Description} from '@blocks/authv2/components/ChangePassword/Description';
import {QuestionInput} from '@blocks/authv2/components/ChangePassword/QuestionInput';
import {BindPhone} from '@blocks/authv2/components/ChangePassword/BindPhone';
import {Finish} from '@blocks/authv2/components/ChangePassword/Finish';
import {FinishExp} from '@blocks/authv2/components/ChangePassword/FinishExp';
import {Info} from '@blocks/authv2/components/ChangePassword/Info';

export class ChangePasswordForm extends PureComponent {
    render() {
        const {step} = this.props;

        switch (step) {
            case 'textExp':
                return <Info />;
            case 'text':
                return <Description />;
            case 'question':
                return <QuestionInput />;
            case 'captcha':
                return <CaptchaInput />;
            case 'phone':
                return <PhoneInput />;
            case 'password':
                return <PasswordInput />;
            case 'bind-phone':
                return <BindPhone />;
            case 'finish':
                return <Finish />;
            case 'finishExp':
                return <FinishExp />;
            default:
                return <Description />;
        }
    }
}

ChangePasswordForm.propTypes = {
    step: PropTypes.string.isRequired,
    updateChangePasswordStep: PropTypes.func.isRequired
};
