import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import './Description.styl';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import metrika from '@blocks/metrics';
import Title from '@blocks/authv2/components/Title/Title';
import {LandingLink} from '../LandingLink/LandingLink';

const b = cn('ChangePassword');

export class Description extends PureComponent {
    componentDidMount() {
        metrika.send(['Показ экрана принудительной смены пароля', `причина: ${this.props.reason}`]);
    }

    proceedToNextStep = () => {
        const {isSemiauto, semiautoUrl, nextStep} = this.props;

        if (isSemiauto) {
            location.href = semiautoUrl;
            return;
        }
        this.props.updateChangePasswordStep(nextStep);
    };

    render() {
        const {text, buttonText} = this.props;

        return (
            <Fragment>
                <Title>{i18n('_AUTH_.account_access_restricted')}</Title>
                <div className={`passp-normal_margin-form`}>
                    <div className={b('description')} dangerouslySetInnerHTML={{__html: text}} />
                    <div data-t='pssp:submit-gocaptcha-btn'>
                        <Button onClick={this.proceedToNextStep} text={buttonText} width='max' size='l' />
                    </div>
                </div>
                <LandingLink />
            </Fragment>
        );
    }
}

Description.propTypes = {
    reason: PropTypes.string,
    isSemiauto: PropTypes.bool.isRequired,
    semiautoUrl: PropTypes.string.isRequired,
    nextStep: PropTypes.string.isRequired,
    text: PropTypes.string.isRequired,
    buttonText: PropTypes.string,
    updateChangePasswordStep: PropTypes.func.isRequired
};
