import {connect} from 'react-redux';
import {Description} from './Description.jsx';
import {updateChangePasswordStep} from '@blocks/authv2/actions/forcePasswordChange';
import {formatLocTextWithLink} from '@blocks/authv2/utils/formatLocTextWithLink';

const mapStateToProps = (state = {}) => {
    const {
        auth: {form},
        changePassword: {reason, number, question, semiautoUrl},
        settings: {tld}
    } = state;
    const {login} = form;
    const SUPPORT_LINK = `https://yandex.${tld}/support/passport/security/force-password-change.html`;
    const isSkipVerifyAllowed = reason === 'password_expired' || reason === 'password_weak';
    const nextStep = isSkipVerifyAllowed ? 'password' : 'captcha';
    const isSemiauto = !number && !question && !isSkipVerifyAllowed;
    const semiautoText = i18n('_AUTH_.account_cant_auto_restore').replace('%login%', `<strong>${login}</strong>`);
    const passwordExpiredTextChunk = formatLocTextWithLink(
        i18n('_AUTH_.password_expired_upd'),
        `https://yandex.${tld}/support/passport/security.html#password-done-right`
    );
    const commonDescriptionText = formatLocTextWithLink(i18n('_AUTH_.account_hacked_common_descr'), SUPPORT_LINK);
    const passwordExpiredText = formatLocTextWithLink(passwordExpiredTextChunk, 'https://idm.yandex-team.ru/');
    const forceChangePasswordTexts = {
        account_hacked: formatLocTextWithLink(semiautoText, semiautoUrl),
        password_flushed: i18n('_AUTH_.password_flushed'),
        password_weak: passwordExpiredText,
        password_expired: passwordExpiredText,
        account_hacked_phone: commonDescriptionText,
        account_hacked_no_phone: commonDescriptionText
    };

    return {
        reason,
        isSemiauto,
        semiautoUrl,
        nextStep,
        text: forceChangePasswordTexts[reason],
        buttonText: isSemiauto ? i18n('_AUTH_.fill_in_form') : i18n('_AUTH_.RestoreLogin.next-step')
    };
};

const mapDispatchToProps = {
    updateChangePasswordStep
};

const ConnectedDescription = connect(mapStateToProps, mapDispatchToProps)(Description);

export {ConnectedDescription as Description};
