import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import Title from '@blocks/authv2/components/Title/Title';
import {formatLocTextWithLink} from '@blocks/authv2/utils/formatLocTextWithLink';

const PHONES_URL = '/profile/phones';
const phoneChangeNote = formatLocTextWithLink(i18n('_AUTH_.change-phone_warning'), PHONES_URL);
const phoneConflictWarning = formatLocTextWithLink(i18n('_AUTH_.phone-bind_conflict-operation'), PHONES_URL);
const mainText = formatLocTextWithLink(
    i18n('_AUTH_.finish_text'),
    'https://yandex.%tld/support/passport/authorization/twofa-on.html'
);

const b = cn('ChangePassword');

export class Finish extends PureComponent {
    render() {
        const {retpath, profileUrl, isPhoneNumberUpdated, isPhoneOperationConflict, tld} = this.props;

        return (
            <>
                <Title>{i18n('_AUTH_.password_successfully_changed')}</Title>
                <div className={`passp-normal_margin-form`}>
                    <div className={b('description')}>
                        <p dangerouslySetInnerHTML={{__html: mainText.replace('%tld', tld)}} />
                    </div>

                    {isPhoneNumberUpdated && !isPhoneOperationConflict && (
                        <div className={b('description')}>
                            <p dangerouslySetInnerHTML={{__html: phoneChangeNote}} />
                        </div>
                    )}
                    {isPhoneOperationConflict && (
                        <div className={b('description')}>
                            <p dangerouslySetInnerHTML={{__html: phoneConflictWarning}} />
                        </div>
                    )}
                    <div data-t='pssp:submit-finish-btn'>
                        <Button
                            type='link'
                            size='l'
                            url={retpath || profileUrl}
                            view='action'
                            width='max'
                            text={i18n('_AUTH_.RestoreLogin.next-step')}
                        />
                    </div>
                </div>
            </>
        );
    }
}

Finish.propTypes = {
    profileUrl: PropTypes.string,
    retpath: PropTypes.string,
    isPhoneNumberUpdated: PropTypes.bool,
    isPhoneOperationConflict: PropTypes.bool,
    tld: PropTypes.string,
    setupMode: PropTypes.func.isRequired
};
